;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: DAC8_1.asm
;;   Version: 2.2, Updated on 2004/10/19 at 16:16:45
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: DAC8 User Module software implementation file
;;               for 22/24/25/26/27xxx PSoC family of devices.
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2001-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "DAC8_1.inc"
include "m8c.inc"
include "memory.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  DAC8_1_Start
export _DAC8_1_Start
export  DAC8_1_SetPower
export _DAC8_1_SetPower

export  DAC8_1_WriteBlind
export _DAC8_1_WriteBlind
export  DAC8_1_WriteBlind2B
export _DAC8_1_WriteBlind2B

export  DAC8_1_WriteStall
export _DAC8_1_WriteStall
export  DAC8_1_WriteStall2B
export _DAC8_1_WriteStall2B

export  DAC8_1_Stop
export _DAC8_1_Stop

;-----------------------------------------------
;  EQUATES
;-----------------------------------------------

cOFFSET:   equ 127              ; Conversion term for offset binary to 2's C
bPWRMASK:  equ 03h              ; Power bitfield in Switched Cap CR3 reg
bSPLITMASK:equ 03h              ; Marks split between MSB and LSB bits
bSMMASK:   equ 3Fh              ; Sign and Magnitude bits mask
bSIGNMASK: equ 20h              ; Sign bit mask

    AREA UserModules (ROM, REL)

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DAC8_1_Start
;  FUNCTION NAME: DAC8_1_SetPower
;
;  DESCRIPTION:
;    Applies power setting to the module's analog PSoC blocks.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A contains the power setting 0=Off, 1=Low, 2=Med, 3=High.
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DAC8_1_Start:
_DAC8_1_Start:
 DAC8_1_SetPower:
_DAC8_1_SetPower:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and   A, bPWRMASK       ; trim input to bits of interest
    mov   X, SP             ; Set stack frame pointer
    push  A
    ;; read CR3 registers, modify power bits & write back
    mov   A, reg[DAC8_1_MSB_CR3]
    and   a, ~bPWRMASK      ; clear old setting
    or    A, [X]            ; set power in MSB register image
    mov   reg[DAC8_1_MSB_CR3], A
    mov   A, reg[DAC8_1_LSB_CR3]
    and   a, ~bPWRMASK      ; clear old setting
    or    A, [X]            ; set power in LSB register image
    mov   reg[DAC8_1_LSB_CR3], A
    pop   A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DAC8_1_WriteBlind
;  FUNCTION NAME: DAC8_1_WriteBlind2B
;
;  DESCRIPTION:
;    Modify the DAC's update value without worrying about the clocks
;    Lowest overhead, but may cause glitches on the output.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A contains the update value if data format is offset binary or
;    2's complement. If format is 2-byte sign-and-magnitude, the LSB is in
;    A (as 00smmmmm) and the MSB is in X (as 00xmm000, where x=s\, the
;    inverted sign.
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DAC8_1_WriteBlind:
_DAC8_1_WriteBlind:
    RAM_PROLOGUE RAM_USE_CLASS_2
  IF DAC8_1_OFFSETBINARY
    ;; Data is an unsigned byte value in [0..254] (i.e., 255 unique values).
    ;; Following converts it to 2's complement:
    sub   A, cOFFSET            ; Convert to 2's Complement
  ENDIF
  IF DAC8_1_OFFSETBINARY | DAC8_1_TWOSCOMPLEMENT
    mov   X, SP
    push  A                     ; Preserve the sign
    cmp   A, 80h                ; negative (or zero)?
    jc    BlindAdjustCycles     ;   no: just go on
    cpl   A                     ;  yes: take the 2's Complement
    inc   A
    jmp   BlindMagSet
BlindAdjustCycles:
    cpl   A                     ; these 3 instructions implement a 13-cycle
    cpl   A                     ;   NOP so it takes the same amount of time
    jmp   BlindMagSet           ;   for both positive and negative numbers.
BlindMagSet:
    push  A                     ; preserve LSB magnitude bits
    and   [X+1], bSPLITMASK
    and   [X], 80h              ; isolate the sign
    or    A, [X]                ; insert in MSB
    asr   A                     ; justify MSB sign & mag
    asr   A
    and   A, bSMMASK            ; clear sign extension bits
                                ; Set FCap and ClockPhase bits for MSB
    mov   [X], A                ; stash the MSB
    and   A, bSIGNMASK          ; isolate the sign
    xor   A, bSIGNMASK          ;   and invert for LSB
    asl   [X+1]                 ; justify LSB magnitude
    asl   [X+1]
    asl   [X+1]
    or    A, [X+1]              ; combine LSB magnitude with sign
                                ; Set FCap and ClockPhase bits for LSB
    pop   X                     ; Put MSB in X
    pop   X
  ENDIF
    or    A, DAC8_1_CR0_HIBITS
    swap  A, X
    or    A, DAC8_1_CR0_HIBITS
    mov   reg[DAC8_1_MSB_CR0], A
    mov   A, X
    mov   reg[DAC8_1_LSB_CR0], A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret


 DAC8_1_WriteBlind2B:
_DAC8_1_WriteBlind2B:
    RAM_PROLOGUE RAM_USE_CLASS_1
    or    A, DAC8_1_CR0_HIBITS
    swap  A, X
    or    A, DAC8_1_CR0_HIBITS
    mov   reg[DAC8_1_MSB_CR0], A
    mov   A, X
    mov   reg[DAC8_1_LSB_CR0], A
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DAC8_1_WriteStall
;  FUNCTION NAME: DAC8_1_WriteStall2B
;
;  DESCRIPTION:
;    Modify the DAC's update value, stalling the CPU if necessary.
;    This routine should be used with faster analog clocks or when the
;    effect of prolonging interrupt latencies can be safely tolerated.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;   A contains the update value if data format is offset binary or
;   2's complement. If format is 2-byte sign-and-magnitude, the LSB is in
;   A (as 00smmmmm) and the MSB is in X (as 00xmm000, where x=s\, the
;   inverted sign.
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;
;  THEORY of OPERATION or PROCEDURE:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DAC8_1_WriteStall:
_DAC8_1_WriteStall:
    RAM_PROLOGUE RAM_USE_CLASS_2
  IF DAC8_1_OFFSETBINARY
    ;; Data is an unsigned byte value in [0..254] (i.e., 255 unique values).
    ;; Following converts it to 2's complement:
    sub   A, cOFFSET            ; Convert to 2's Complement
  ENDIF
  IF DAC8_1_OFFSETBINARY | DAC8_1_TWOSCOMPLEMENT
    mov   X, SP
    push  A                     ; Preserve the sign
    cmp   A, 80h                ; negative (or zero)?
    jc    StallAdjustCycles     ;   no: just go on
    cpl   A                     ;  yes: take the 2's Complement
    inc   A
    jmp   StallMagSet
StallAdjustCycles:
    cpl   A                     ; these 3 instructions implement a 13-cycle
    cpl   A                     ;   NOP so it takes the same amount of time
    jmp   StallMagSet           ;   for both positive and negative numbers.
StallMagSet:
    push  A                     ; preserve LSB magnitude bits
    and   [X+1], bSPLITMASK
    and   [X], 80h              ; isolate the sign
    or    A, [X]                ; insert in MSB
    asr   A                     ; justify MSB sign & mag
    asr   A
    and   A, bSMMASK            ; clear sign extension bits
                                ; Set FCap and ClockPhase bits for MSB
    mov   [X], A                ; stash the MSB
    and   A, bSIGNMASK          ; isolate the sign
    xor   A, bSIGNMASK          ;   and invert for LSB
    asl   [X+1]                 ; justify LSB magnitude
    asl   [X+1]
    asl   [X+1]
    or    A, [X+1]              ; combine LSB magnitude with sign
                                ; Set FCap and ClockPhase bits for LSB
    pop   X                     ; Put MSB in X
    pop   X
  ENDIF
    or    A, DAC8_1_CR0_HIBITS
    swap  A, X
    or    A, DAC8_1_CR0_HIBITS

    M8C_Stall
    mov   reg[DAC8_1_MSB_CR0], A
    M8C_Unstall
    mov   A, X
    mov   reg[DAC8_1_LSB_CR0], A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

 DAC8_1_WriteStall2B:
_DAC8_1_WriteStall2B:
    RAM_PROLOGUE RAM_USE_CLASS_1
    or    A, DAC8_1_CR0_HIBITS
    swap  A, X
    or    A, DAC8_1_CR0_HIBITS

    M8C_Stall
    mov   reg[DAC8_1_MSB_CR0], A
    M8C_Unstall
    mov   A, X
    mov   reg[DAC8_1_LSB_CR0], A
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DAC8_1_Stop
;
;  DESCRIPTION:
;    Cuts power to the user module.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DAC8_1_Stop:
_DAC8_1_Stop:
    RAM_PROLOGUE RAM_USE_CLASS_1
    and  reg[DAC8_1_MSB_CR3], ~bPWRMASK
    and  reg[DAC8_1_LSB_CR3], ~bPWRMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.ENDSECTION
; End of File DAC8_1.asm
